% Method -- Least Square Fit to Differential Equation Model by Newton's
% (?)Gradient Method.
%  
% The best parameter values, initial condiations, and the realative square
% error are saved in the file 'Data.mat', for which the last point of 
% variable 'SearchPath' is the end point of the search, all points are 
% in the order of parameters and then initial points.
% 
% 
% Example -- Logisitc Equation 
%
%  To adapt it to your model, modify the input with '%%%' comments
%  and create the following m.files without change the file names:
%      
%      VariationDEModel.m
%      FitFunctions.m
%      ParameterJacobianOfFitFunctions.m
%      VariableJacobianOfFitFunctions.m
%      
%      
clear all

% Do Not Change the Following global parameters
global VariableNames ParameterNames NumberOfVariables NumberOfParameters 
global Parameters4Search InitialConditions4Search SearchParaNVar SearchParaNVarInitials  
global ExpeTime ExpeData LengthOfExpeData DimensionOfExpeData RealDataSelection FitWeights ExpeDataRange
global StopError StopIterate SearchStepSize

%%% Define parameter names, modify entries in quotations only.
ParameterNames={'r', 'm'};

%%% Specify the starting parameter values. Do Not Change the vector name. 
ParameterValues=[1.1661    0.5374  ];
ParameterValues=[1   0.1  ];

%%% Specify which parameter(s) the program is used to search and determine.
Parameters4Search={'r', 'm'};
% Parameters4Search=ParameterNames % If all the parameters are to be determined 
% Parameters4Search=[] % If none of the parameters is to be determined 


%%% Define variable names. Modify entries in quotations only. Add more if needed. 
VariableNames={'Population'};

%%% Specify which initial(s) the program is also used to search and determine.

InitialConditions4Search={'Population'};

% InitialConditions4Search=VariableNames % if all IC are to be searched.
% InitialConditions4Search=[] % if none of the IC is to be searched.

%%% 
%%% Specify the initial conditions in a row vector. Do Not Change the vector name. 
InitialConditions=[   0.68451];
InitialConditions=[1];

 

%%% Enter the discrete times at which the empirical data are collected.
%%% It must be a column vector. Idential time entries are allowed, which 
%%% can be used to aggregate different data sets. 
%%% Do not change the name, ExpeTime. 
ExpeTime=[ 0.0055;    0.5014;    1.0015;    1.5026;    2.0084;    2.5025;  3.0081;    3.5024;    4.0093;    4.5035;    5.0020];

%%% Enter the corresponding empirical data.
%%% It must be a column vector, and do not change the name.
%%% For any additional set of data corresponding to the SAME discrete time, ExpeTime,
%%% just add another column to the ExpeData matrix. 
ExpeData=[ 0.4253;    0.9855;    1.4145;    1.6956;    1.9951;    1.9860;   2.0002;    2.1197;    1.9337;    2.0764;    2.0758];


%%% Create a binary column sequence of the length of ExpeData so that an entry 1
%%% for a real entry and 0 for an auxilliary entry when aggregation of more
%%% than one data sets at different discrete times is needed. 
%%% Add more for multimple data sets when aggregation is required.
RealDataSelection=ones(length(ExpeData),1); % If all ExpeData entries are real. 

RealDataSelection(end-2)=0; %%% For example, two points are taken out from the search.
RealDataSelection(end-7)=0;

%%% For multi-dimensional data set, specify the weight the least
%%% square relative error (LSRE) weighs on each dimensional data. 
%%%
%%%
FitWeights=[1]; % Unit weight for 1-dimensional data set. For example, use
                % [1/2 1/2] for equal weight of a 2-dimensional data set.

%%% Specify the conditions to stop the program search. 
%%%
%%%
StopError=1e-2; % Search stops if the RelativeSquareErrors < StopError
StopIterate=2000;  % Seach stops if the number of iteration exceeds StopIterate. 

SearchStepSize=.03; % Step size for the gradient search of parameter and initial conditions
SearchStepJump=1; % Number of steps taken along the gradient before reupdating. 

%%%%%%%%%
%%%%%%%%% With the completion of the required user-specific m.files, this
%%%%%%%%% complete the input to the program. Run it from this point on. 
%%%%%%%%%


%%%%%%%%%  Do Not Make Any Change Below, except for plots.  
%%%%%%%%%

NumberOfVariables=length(VariableNames);
NumberOfParameters=length(ParameterNames);

LengthOfExpeData=length(ExpeTime);
DimensionOfExpeData=length(ExpeData(1,:));

%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Find 'ExpeDataRange'.
%%%%%%%%%%%%%%%%%%%%

ExpeDataRange=max(ExpeData,[],1)-min(ExpeData,[],1);
ZeroDifference=(ExpeDataRange==0);
ExpeDataRange=ExpeDataRange+ZeroDifference;

%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%

nmbrofvariations=NumberOfParameters*NumberOfVariables;


% Create a binary sequence for those parameters and initial conditions with
% which the program is to find the best values. 
SearchParaNVar = SearchingVariables(Parameters4Search,InitialConditions4Search,ParameterNames,VariableNames);

tinit=min(ExpeTime);
tend=max(ExpeTime);


OldLSError=1e+8;
NewLSError=1;
counter=1;

options=odeset('RelTol',1e-4,'AbsTol',1e-6);
parameters=ParameterValues;
IdMtrx=eye(NumberOfVariables,NumberOfVariables);

SearchParaNVarInitials=ones(NumberOfVariables,1)*SearchParaNVar';
SearchParaNVarInitials=SearchParaNVarInitials(1:end)';

xinit=[InitialConditions zeros(1,nmbrofvariations) IdMtrx(1:end)].*[ones(NumberOfVariables,1);SearchParaNVarInitials]';

for DataCoordinate=1:DimensionOfExpeData
figure(DataCoordinate)  
hold off
plot(ExpeTime,ExpeData(:,DataCoordinate), 'bo')
hold on
end


SearchPath=[ParameterValues,InitialConditions];
RelativeSquareErrors=[NewLSError];
%while abs(NewLSError-OldLSError)>StopError & counter<StopIterate;
while NewLSError>StopError & counter<StopIterate;
        [t,y]=ode15s('VariationDEModel',[tinit tend],xinit, options, parameters);
        yExpeData=[];
        TimeIndx=ExpeTime';
        for i=TimeIndx
            idx=(t>=i);
            aa=y(idx,:);
            yExpeData=[yExpeData;aa(1,:)];
        end
        OldLSError=NewLSError;
        NewLSError=RelativeSquareError(yExpeData,parameters);
        RelativeSquareErrors=[RelativeSquareErrors,NewLSError];
                FF=FitFunctions(t,y(:,1:NumberOfVariables),parameters);
        if counter==1
            for DataCoordinate=1:DimensionOfExpeData
                figure(DataCoordinate)
            plot(t,FF(:,DataCoordinate),'m-','linewidth',2.5)
            end
        end

        
        pinit=[parameters,xinit(1:NumberOfVariables)];
        [s,z]=ode15s('GradientOfRelativeSquareErrorModel',[0 SearchStepSize],pinit,options,yExpeData, parameters);
        
        Skip=min([SearchStepJump+1,length(s)]);
        SearchPath=[SearchPath;z(Skip,:)];
        xinit(1:NumberOfVariables)=z(Skip,end-NumberOfVariables+1:end);
        parameters=z(Skip,1:NumberOfParameters);
        
counter=counter+1;
if mod(counter,100)==0
    counter
    for DataCoordinate=1:DimensionOfExpeData
        figure(DataCoordinate)
    plot(t,FF(:,DataCoordinate),'r-')
    end
    save('Data.m', 'SearchPath', 'RelativeSquareErrors'); 
end

end

for DataCoordinate=1:DimensionOfExpeData
    figure(DataCoordinate)
plot(t,FF(:,DataCoordinate),'b-','linewidth',2.5)
end

figure(11)
hold off
plot3(SearchPath(:,1),SearchPath(:,2),SearchPath(:,3))
hold on
plot3(SearchPath(1,1),SearchPath(1,2),SearchPath(1,3),'m.',...
    SearchPath(end,1),SearchPath(end,2),SearchPath(end,3),'r.','markersize',10)
text(1.05*SearchPath(end,1),1.05*SearchPath(end,2),1.05*SearchPath(end,3),'End of the Search')
grid on

{'Parameters','Initial Conditions', 'RelativeSquareError'}
[parameters, xinit(1:NumberOfVariables), NewLSError]

return
  