%
% The commands hereon are for visualization of the best-fit in various
% plots. 
%

%load BestFitHHAxon17DengModel.mat ModelName options VariableNames ParameterNames Variables4Search Parameters4Search ExperimentData PredictedState FitInit FitParam FitError FitSens StateFit2Data Errorfunction SearchStepTaken  RunOrNoRun NumberOfRun NumberOfSearchPartition StopThreshold MaximalSearchIterate InitialConditions RangeScale 

%% 
FitByConstraint=(1:NumberOfRun)';

figure(1)
hold off

[sorteder, idx]=sort(FitError(FitByConstraint,:)); % sort FitError in increasing values.  
k=idx(1); 
SelectedFitByConstraint=FitByConstraint(k);

n=length(SelectedFitByConstraint);
clr=colormap(cool(2*n));

scl=0.04; % to scale to dimensional unit

plot([-110 -110],[0 0],'-r','linewidth',3) % out of sight

hold on
%plot([-110 -110],[0 0],'kd','markersize',10)
hold on
plot([-110 -110],[0 0],'ro','markerfacecolor','w','markersize',10)
plot([-110 -110],[0 0],'m--','linewidth',3) % out of sight

plot([-110 -110],[0 0],'b-.','linewidth',3) % out of sight

plot([-110 -110],[0 0],'g-','linewidth',3) % out of sight

AX=legend('HH Axon 17',' V', ' I_{K}',' I_{Na}',' I_{G}');
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',14)

E_K=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,1)');
a_K=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,2)');
E_Na=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,4)');
a_Na=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,5)');
E_G=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,7)');
a_G=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,8)');
b_G=ones(length(StateFit2Data(:,2,1)),1)*(FitParam(SelectedFitByConstraint,9)');

V=reshape(StateFit2Data(:,2,SelectedFitByConstraint),[length(StateFit2Data(:,2,1)),length(SelectedFitByConstraint)]);
G_K=reshape(StateFit2Data(:,3,SelectedFitByConstraint),[length(StateFit2Data(:,2,1)),length(SelectedFitByConstraint)]);
G_Na=reshape(StateFit2Data(:,4,SelectedFitByConstraint),[length(StateFit2Data(:,2,1)),length(SelectedFitByConstraint)]);
G_G=reshape(StateFit2Data(:,5,SelectedFitByConstraint),[length(StateFit2Data(:,2,1)),length(SelectedFitByConstraint)]);

I_K=a_K.*G_K.*(V-E_K);
I_Na=a_Na.*G_Na.*(V-E_Na);
I_G=a_G.*G_G.*(V-E_G);

Vagrt=mean(V,2);
I_Kagrt=mean(I_K,2);
I_Naagrt=mean(I_Na,2);
I_Gagrt=mean(I_G,2);

Vend=Vagrt(end);%+.016;
offst=0;

plot(ExperimentData(:,1),scl*I_Kagrt,'m--','linewidth',3)
plot(ExperimentData(:,1),scl*I_Naagrt,'b-.','linewidth',3)
plot(ExperimentData(:,1),scl*I_Gagrt,'g-','linewidth',3)

plot(ExperimentData(:,1),0*ExperimentData(:,1),'--','color',[.7 .7 .7],'linewidth',1)

plot(ExperimentData(:,1),ExperimentData(:,2)-offst*Vend,'r-','linewidth',3);

plot(ExperimentData(:,1),ExperimentData(:,2)-offst*Vend,'r.','markersize',18);

for i=1:n
k=SelectedFitByConstraint(i);
end

plot(ExperimentData(:,1),Vagrt-offst*Vend,'ro','markerfacecolor','w','markersize',10)

set(gca,'XTick',[0 1 2 3 4 5 6])
aa = get(gca,'XTickLabel');
set(gca,'XTickLabel',aa,'fontsize',14)

plot([4.8 5.2],[-10 -10],'k-',[4.8 5.2],[-30 -30],'k-',[5 5],[-10 -30],'k-')
text(5.2, -20, '500\muA','fontsize',16)
xlabel('Time (msec)','fontsize',20)

ylabel('V (mV)','fontsize',20)

axis([-.2 6.4 -70 80])

DataWeight=ExperimentData(:,3);

DataId=(DataWeight'>0);

plot(ExperimentData(DataId,1),Vagrt(DataId)-offst*Vend,'ko','markerfacecolor',[.7 .7 .7],'markersize',10)
%%
figure(3)
hold off

g_NaG=(I_Na+I_G)./(V-E_Na);
g_NaGagrt=mean(g_NaG,2);

g_KG=(I_K+I_G)./(V-E_K);
g_KGagrt=mean(g_KG,2);

gg_K=a_K.*G_K;
gg_Na=a_Na.*G_Na;
gg_G=a_G.*G_G;

gg_Kagrt=mean(gg_K,2);
gg_Naagrt=mean(gg_Na,2);
gg_Gagrt=mean(gg_G,2);

plot(ExperimentData(:,1),gg_Kagrt,'m--','linewidth',3)
hold on

plot(ExperimentData(:,1),gg_Naagrt,'b-.','linewidth',3)
plot(ExperimentData(:,1),gg_Gagrt,'g-','linewidth',3)

AX=legend('g_K', 'g_{Na}', 'g_G');
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',14)

set(gca,'XTick',[0 1 2 3 4 5 6])
aa = get(gca,'XTickLabel');
set(gca,'XTickLabel',aa,'fontsize',14)

xlabel('Time (msec)','fontsize',20)
ylabel('Conductance (m.mho/cm^2)','fontsize',20)

axis([-.2 6.4 -5 65])

%%
%
% Plot the error against search parameters in dimensionless percentile. 
%
%%%%%%%%%%%%% Plot the fit in sensitivity

NumberOfVariables=length(VariableNames); 
NumberOfParameters=length(ParameterNames);
VariableNdParameterNames=union(VariableNames,ParameterNames,'stable');
NumberOfVarNdParam=NumberOfVariables+NumberOfParameters;

ErrorPlotVarNdParam=union(Variables4Search,Parameters4Search,'stable');

cc=colormap(cool(NumberOfVarNdParam));
selparam=varndparamid(ErrorPlotVarNdParam, VariableNames,ParameterNames);
meanerrorperdatapoint=mean(FitError(SelectedFitByConstraint,:),1);

%%
figure(2)
hold off

inc=1/(NumberOfSearchPartition);
percentile = -1:inc:1;

AggrgtError=zeros(2*NumberOfSearchPartition+1,NumberOfVarNdParam);
for j=1:NumberOfVarNdParam
AggrgtError(:,j)=mean(Errorfunction(:,2,j,SelectedFitByConstraint),4);
end

cc=hsv(length(ErrorPlotVarNdParam));

kk=1;
for j=selparam
plot(percentile,AggrgtError(:,j), 'color',cc(kk,:), 'linewidth',2,'markersize',2)
kk=kk+1;
hold on
end

AX=legend(VariableNdParameterNames(selparam));
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',16)

for j=selparam
plot(percentile,AggrgtError(:,j), 'ko','markerfacecolor', 'w','markersize',4)
end

plot([0 0],[meanerrorperdatapoint meanerrorperdatapoint],'ko','markerfacecolor', [.7 .7 .7] ,'markersize',5)

set(gca,'XTick',[-1 -0.5 0 0.5 1],'XTickLabel',{'-100' '-50' '0' '50' '100'},'fontsize',14)

ytick=((0:1:4)*meanerrorperdatapoint*.4/4+meanerrorperdatapoint*.97);

box on
xlabel('Percentile Change in Pararmeter','FontSize',20)
ylabel('Error Per Data Point','FontSize',20)

axis([-1 1 meanerrorperdatapoint*.95 meanerrorperdatapoint*2])

%%
figure(5)
hold off

% var and param whose compositie sensitivity is to shown, in the same order
% as their name so that they will be labeled correctly. 
                                   
PointPlotOfVarOrParam1={'tau_K', 'tau_Na', 'tau_G'}; 
PointPlotOfVarOrParam2={'E_G','barg_G','b_G'}; 
PointPlotOfVarOrParam3={'b_K','barg_Na','b_Na'}; 

PointPlotOfVarOrParam=PointPlotOfVarOrParam3;  

plotVarOrParam=varndparamid(PointPlotOfVarOrParam, VariableNames,ParameterNames);


kk=SelectedFitByConstraint;
nn=length(kk);
clr=colormap(cool(nn));

PointofBestFit=[FitInit(kk,:) FitParam(kk,:) FitError(kk,:)];

plotfits=PointofBestFit(:,plotVarOrParam);

for i=1:length(plotfits(:,1))
plot3(plotfits(i,1),plotfits(i,2),plotfits(i,3),'ko','markerfacecolor',clr(i,:),'markersize',14)
hold on
end

[a,b]=meshgrid(0:.05:1, 0:.05:1);
c1=0.*a+0;

xx=8+a*(13-8);
yy=85+b*(320-85);
zz=19.5+b*(14-19.5);
mesh(xx, yy, zz, c1); 

xlabel(PointPlotOfVarOrParam3(1),'fontsize',20)
ylabel(PointPlotOfVarOrParam3(2),'fontsize',20)
zlabel(PointPlotOfVarOrParam3(3),'fontsize',20)

grid on
hidden off
axis([-inf inf -inf inf -inf inf])
view(-125, 20)