clear all
%
%  User Defined Input of the program
%
ModelName = 'HHmodel'; %
options=odeset('e','off','BDF','on','AbsTol',1e-6,'RelTol',1e-6); % for solve ode, use =[] for default.

VariableNames = {'V','n','m', 'h'};
ParameterNames = {'V_K', 'barg_K',  'V_Na', 'barg_Na', 'V_L', 'barg_L', 'C', 'Iin', 't_depol','timescale'}; 

%%
%%% Specify searching parameters. 
%%%

%Parameters4Search = {'V_K', 'barg_K',  'V_Na', 'barg_Na', 'V_L', 'barg_L', 'C', 'Iin', 't_depol','timescale'}; 
Parameters4Search = {         'barg_Na', 'V_L', 'barg_L',                                  }; 

%Variables4Search={'n','m', 'h'};
Variables4Search={};

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% Input Control Parameters %%%%%%%%%%%
RunOrNoRun=1; % Binary. If 0, no search is done but output the initial fit. If =1, search for each of the InitialConditions

NumberOfRun=1; % if RunOrNoRun=1, NumberOfRun are searched with InitialConditions and the rest randomly choosen within the RangeScale of the first of InitialConditions.



RangeScale=1.2;

NumberOfSearchPartition=15; % On each search line in one direction of the initial/iterative fit.

transienttime=-1; % to set an initial state before data is fitted to the fit functional.

%%%% Specify the stop conditions for the search loops
StopThreshold=.0001;
MaximalSearchIterate=inf; % A finite number if StopThreshold is not met, otherwise inf

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Input initial fit variables and parameters %%%%%%%%%%%%%%%%%%%%

V_K=-12;
barg_K=36;
V_Na=115;
barg_Na=120;
V_L=10.6;
barg_L=0.3;
C=.5; % with offset 0.5.

Iin=0; 
t_depol=1;

timescale=1;

        xinit=[26.9000    0.3665    0.0251    0.5246];    %
        param=[V_K, barg_K, V_Na, barg_Na, V_L, barg_L, C, Iin, t_depol, timescale]; 
             
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

InitialConditions=[xinit param]; %   
OriginalSearchPoint=InitialConditions;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% or if RunOrNoRun> length of InitialConditions, random searches are
% included. 
%
pstvsign=(InitialConditions(1,:)>0);
ngtvsign=1-pstvsign;
InitialSearchRangeLow=(1/RangeScale)*pstvsign.*InitialConditions(1,:)+RangeScale*ngtvsign.*InitialConditions(1,:);
InitialSearchRangeHigh=RangeScale*pstvsign.*InitialConditions(1,:)+(1/RangeScale)*ngtvsign.*InitialConditions(1,:);

if RunOrNoRun>0
    NumberOfVariables=length(VariableNames); 
    NumberOfParameters=length(ParameterNames);
    VariableNdParameterNames= union(VariableNames,ParameterNames,'stable');
    VariablesNdParameters4Search = union(Variables4Search,Parameters4Search,'stable');

    SearchVariablesNdParameters=zeros(1,NumberOfVariables+NumberOfParameters); %creat binary sequence with 1 for search 0 for nonsearch.
    for k = 1:length(VariablesNdParameters4Search)
        jj = strcmp(VariablesNdParameters4Search(k),VariableNdParameterNames);
        SearchVariablesNdParameters = SearchVariablesNdParameters+jj;
    end
        rand(ceil(50*rand)); 
        InitialSearchPoint=rand(NumberOfRun, NumberOfVariables+NumberOfParameters);
        InitialSearchPoint=ones(NumberOfRun,1)*InitialSearchRangeLow+InitialSearchPoint.*(ones(NumberOfRun,1)*(InitialSearchRangeHigh-InitialSearchRangeLow));
            SearchVariablesNdParametersArray = ones(NumberOfRun, 1)*SearchVariablesNdParameters;
            NonSearchVariablesNdParametersArray = (1-SearchVariablesNdParametersArray);
    InitialSearchPoint =InitialSearchPoint.*SearchVariablesNdParametersArray + NonSearchVariablesNdParametersArray.*(ones(NumberOfRun, 1)*InitialConditions(1,:));
    InitialSearchPoint(1:length(InitialConditions(:,1)),:)= InitialConditions;
    InitialConditions=InitialSearchPoint;
    OriginalSearchPoint=InitialSearchPoint;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Data Structure for User Defined Input %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Data=[allinclusivetime,data1,data1timeweight1,...,datan,datantimeweightn]
% dateweight at row i >0 but <=1 for observed at time t_i with given weight, 0 otherwise. 
% 
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Data Structure for User Defined Input %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Data=[allinclusivetime,data1,data1timeweight1,...,datan,datantimeweightn]
% dateweight at row i >0 but <=1 for observed at time t_i with given weight, 0 otherwise. 
% 
HH52eAxon17 =[0   26.8293
    0.0735   20.7317
    0.1224   18.2927
    0.2204   17.0732
    0.3184   18.2927
    0.4163   19.5122
    0.5388   23.1707
    0.6367   30.4878
    0.7592   45.1220
    0.8816   75.6098
    0.9306   96.3415
    0.9796  102.4390
    1.0531  106.0976
    1.1020  107.3171
    1.2490  104.8780
    1.4694   95.1220
    1.9347   64.6341
    2.4735   24.3902
    2.8163    2.4390
    3.0367   -3.6585
    3.2571   -7.3171
    3.6490   -8.5366
    4.6286   -7.3171
    5.0694   -7.8171
    6.0000   -4.8780];
ExperimentData(:,1:2) =[HH52eAxon17(:,1), HH52eAxon17(:,2)-50+2.5]; % 

    DataWeightTestOrder =[1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]';    
    DataWeightFirstOrder=[1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1]'; % first order fit
    DataWeightSecondOrder=[1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 1]'; % second order fit 
    DataWeightAll=[1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1]'; % all fit

    DataWeight=DataWeightSecondOrder;

ExperimentData(:,3)=DataWeight;

% Start potasium current estimate
ExperimentData(:,4:5)=0*HH52eAxon17;
% End potasium current estimate

% Start sodium current estimate
ExperimentData(:,6:7)=0*HH52eAxon17;
% End sodium current estimate

% Start gating current estimate
ExperimentData(:,8:9)=0*HH52eAxon17;
% End gating current estimate

ExperimentData(:,5)=0; % 0 for not using current for fit.
ExperimentData(:,7)=0; % 0 for not using current for fit.
ExperimentData(:,9)=0; % 0 for not using current for fit.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Experimental Data Input
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
%%%%%%%%%%%%%%
%%%%%%%%%%%%%% PredictedState is a user defined functional which is used to
%%%%%%%%%%%%%% fit the ExperimentalData. Its variables are 'time,
%%%%%%%%%%%%%% variables, parameters' in column, its output are predicted
%%%%%%%%%%%%%% states consistent with the ExperimentData in its dimensional
%%%%%%%%%%%%%% culumns, excluding the time and the weights columns. 
%%%%%%%%%%%%%%

PredictedState=@fitfunction;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% End of Preparing Input Here.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%
% Run raw search and save the data. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% Structure of Output
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% BestFit=zeros(numbrofrun,(NumberOfVariables+NumberOfParameters) + 1 + (NumberOfVariables+NumberOfParameters) + (NumberOfVariables+NumberOfParameters) + 4); 
% the first set is for the Values, the middle 1 is for the Error, 
% the second is for the Sensitivity of best fit, the last is for the
% initial fit, and 4 more columns record
% the search parameters: StopThreshold, MaximalSearchIterate,
% NumberOfSearchPartition, transienttime.
% Sorted in the increasing value of the error. 

%%%% Errorfunction=zeros(2*NumberOfSearchPartition+1,2,NumberOfVariables+NumberOfParameters, numbrofrun)-1;
%
% column 1 for searched points of one parameter line, column 2 for 
% the corresponding error. Page dimension for NumberOfVarNdParm. Page2
% dimension is for the number of run
%

%%%% StateFit2Data=zeros(length(ExperimentData(:,1)),NumberOfVariables+1,numbrofrun);
%
% Same row length as Experiment Data, columns for state variables plus time, page for
% numbrofrun.
%
NumberOfVariables=length(VariableNames); 
NumberOfParameters=length(ParameterNames);

tic
[FitInit, FitParam, FitError, FitSens, StateFit2Data, Errorfunction, SearchStepTaken]=odelinesearch(ModelName,options,VariableNames, ParameterNames, Variables4Search, ...
    Parameters4Search, ExperimentData, PredictedState, InitialConditions, RunOrNoRun, NumberOfSearchPartition, StopThreshold, MaximalSearchIterate);
BestFit=[FitInit, FitParam, FitError, FitSens,InitialConditions];
toc

%%
%%%%%%% Search variable and parameter in logical binary %%%%%%%
VariableNdParameterNames= union(VariableNames,ParameterNames,'stable');
VariablesNdParameters4Search = union(Variables4Search,Parameters4Search,'stable');

SearchVariablesNdParameters=zeros(1,NumberOfVariables+NumberOfParameters); %creat binary sequence with 1 for search 0 for nonsearch.
for k = 1:length(VariablesNdParameters4Search)
    jj = strcmp(VariablesNdParameters4Search(k),VariableNdParameterNames);
    SearchVariablesNdParameters = SearchVariablesNdParameters+jj;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
% post process
%%%%%%%%%%%
% Screening out those nonconvergent result, and ranking the output in error. 
%
%
BestFit(:,(2*(NumberOfVariables+NumberOfParameters)+1+1):(3*(NumberOfVariables+NumberOfParameters)+1))=OriginalSearchPoint;

if RunOrNoRun>0
CenterOfSearchLines=NumberOfSearchPartition+1;
NumberOfVarNdParam=NumberOfVariables+NumberOfParameters;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%  find local minimum with uniform error at the center
%%%%%%%%%%%%%%%%%%%  serach postion among searched var and param
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%% find runs having uniform error among all searched variables and parameters at the center search position %%%%%%%%%%%%%
[~,selsearchedvarndparam]=find((1:NumberOfVarNdParam).*SearchVariablesNdParameters>0);
nmbofrun=length(BestFit(:,1));
aa=zeros(nmbofrun,length(selsearchedvarndparam)); % deviation at the center search position among searched variables and parameters. 
for i=1:nmbofrun
    aa(i,:)=Errorfunction(CenterOfSearchLines,2,selsearchedvarndparam(1),i)-Errorfunction(CenterOfSearchLines,2,selsearchedvarndparam,i);
end
bb=sum(abs(aa),2); % total deviation for searched var and param.
idx1=(abs(bb)<1e-3); % select those with deviation <1e-N.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%% find runs having local minimum among all searched variables and parameters at the center search position %%%%%%%%%%%%%
sens=BestFit(:,NumberOfVariables+NumberOfParameters+1+1:2*(NumberOfVariables+NumberOfParameters)+1);
cc=(sens<-1); % screen out neagative sensitivity out of tolorance <-N;
dd=sum(abs(cc),2);
idx2=(dd==0); % select true local minimum within tolorance.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

indx=(1-idx1.*idx2>0); % runs not having both local minimum and uniform error at the center search position satisfying the constraint

BestFit(indx,NumberOfVariables+NumberOfParameters+1)=NaN;
Errorfunction(:,:,:,indx)=NaN;
StateFit2Data(:,:,indx)=NaN;

% put it in sorted format according to the ascending order of per data error.
[BestFit,idx]=sortrows(BestFit,NumberOfVariables+NumberOfParameters+1); % sort in fit error
Errorfunction=Errorfunction(:,:,:,idx);
StateFit2Data=StateFit2Data(:,:,idx);
end
%%
% Save output to a file. 
%
%save fitHH52eAX17HHModelBestFit.mat ModelName options VariableNames ParameterNames Variables4Search Parameters4Search ExperimentData PredictedState BestFit FitInit FitParam FitError FitSens StateFit2Data Errorfunction SearchStepTaken NumberOfVariables NumberOfParameters RunOrNoRun NumberOfRun NumberOfSearchPartition StopThreshold MaximalSearchIterate InitialConditions RangeScale SearchVariablesNdParameters

return
%%
