%clear all
%
%load fitHH52eAX17HHModelBestFit.mat ModelName options VariableNames ParameterNames Variables4Search Parameters4Search ExperimentData PredictedState BestFit StateFit2Data Errorfunction SearchStepTaken NumberOfVariables NumberOfParameters RunOrNoRun NumberOfRun NumberOfSearchPartition StopThreshold MaximalSearchIterate InitialConditions RangeScale SearchVariablesNdParameters
FitParam=BestFit(:,NumberOfVariables+1:NumberOfVariables+NumberOfParameters);

%%%%%%% for 'withou k diffusor' use V_K1=V_K2 for the K-IV-curve.
%load fitHH52eAX17HHModel2ndOrderBestFittedInitialofHH.mat ModelName options VariableNames ParameterNames Variables4Search Parameters4Search ExperimentData PredictedState BestFit StateFit2Data Errorfunction RandomOrFixedSearch NumberOfRun NumberOfSearchPartition transienttime StopThreshold MaximalSearchIterate InitialConditions RangeScale SearchVariablesNdParameters

E=.02; % error per point threshold 
%or
TopNBestFit=1; % 0 use error threshold 
SelectAny=[1];
SelectAnyByConstraint=[];%[1 3 4 5 6 7 8 10 11 12]; %Enter position entry to run that entry's best fit. 
% error threshold 
%%%%%%%%%%%%% Structures of data %%%%%%%%%%%%%%%%%%

%%%%%% BestFit=zeros(numbrofrun,(NumberOfVariables+NumberOfParameters) + 1 + (NumberOfVariables+NumberOfParameters) + (NumberOfVariables+NumberOfParameters) + 4); 
% the first set is for the Values, the middle 1 is for the Error, 
% the second is for the Sensitivity of best fit, the last is for the
% initial fit, and 4 more columns record
% the search parameters: StopThreshold, MaximalSearchIterate,
% NumberOfSearchPartition, transienttime.
% Row is for the numuber of run.

%%%%%% Errorfunction=zeros(2*NumberOfSearchPartition+1,2,NumberOfVariables+NumberOfParameters, numbrofrun)-1;
%
% column 1 for searched points of one parameter line, column 2 for 
% the corresponding error. Page dimension for NumberOfVarNdParm. Page2
% dimension is for the number of run
%

%%%%%% StateFit2Data=zeros(length(ExperimentData(:,1)),NumberOfVariables+1,numbrofrun);
%
% Same row length as Data, columns for state variables plus time, page for
% numbrofrun.
%

%%%%%%%%%%%%% Structures of experiment data %%%%%%%%%%%%%%%%%
% Data=[allinclusivetime,data1,data1timeweight1,...,datan,datantimeweightn]
% dateweight at row i >0 but <=1 for observed at time t_i with given weight, 0 otherwise. 
% 

%
% HH52eAxon17=Data(:,1),Data(:,2)*60+50
%

%%
% Process raw fit from the loaded file to generte top fit.
%
NumberOfVariables=length(VariableNames);
NumberOfParameters=length(ParameterNames);
VariableNdParameterNames=union(VariableNames,ParameterNames,'stable');
NumberOfVarNdParam=NumberOfVariables+NumberOfParameters;

fitbyconstraint;

%%

%%%%%%%%%
%
% Output the selected top fit with the constrants: SelectedFitByConstraint
NumberOfFitByConstraint

if TopNBestFit>0 && isempty(SelectAny) && isempty(SelectAnyByConstraint)
    SelectedFitByConstraint=FitByConstraint(1:min(TopNBestFit,NumberOfFitByConstraint));
    TopNBestFit=min(TopNBestFit,NumberOfFitByConstraint);
else
    if TopNBestFit>0 && sum(SelectAny)>0 && isempty(SelectAnyByConstraint)
        %SelectedFitByConstraint=FitByConstraint(SelectAny);
        SelectedFitByConstraint=SelectAny;
    else
        if TopNBestFit>0 && sum(SelectAnyByConstraint)>0
        SelectedFitByConstraint=FitByConstraint(SelectAnyByConstraint);
        end
    end
    if TopNBestFit==0 && isempty(SelectAny) && isempty(SelectAnyByConstraint)
        err=BestFit(FitByConstraint,NumberOfVariables+NumberOfParameters+1);
        dx=(err<E);
        SelectedFitByConstraint=FitByConstraint(dx);
    end    
end

meanerrorperdatapoint=mean(BestFit(SelectedFitByConstraint,NumberOfVariables+NumberOfParameters+1),1)
%return

%%
% Plot top fit against the experiment data. 
%

figure(1)
hold off

plotTopFitToExperimentData;

%%
% 
% Plot the error against search parameters in dimensionless percentile. 
%

ErrorPlotVarNdParam=Parameters4Search;

figure(2)
hold off

plotErrorFunctionForSelectedVarNdParam;


%%
% Find composite sensitivity with AggrgtError from error plot.
%
CenterOfSearchLines=NumberOfSearchPartition+1;

sens=zeros(1,NumberOfVarNdParam);
for i=1:NumberOfVarNdParam
    if SearchVariablesNdParameters(i)==1
            d2error=AggrgtError(CenterOfSearchLines+1,i)-2*AggrgtError(CenterOfSearchLines,i)+AggrgtError(CenterOfSearchLines-1,i);
            dpara2=(percentile(CenterOfSearchLines+1)-percentile(CenterOfSearchLines))^2;
        sens(i)=(.5)*(AggrgtError(CenterOfSearchLines,i)^2)*d2error/dpara2;
    end
end

%return
%%
% Selected composite sensitivity 
%
CompoSensVarOrParam={'C'}; % var and param whose compositie sensitivity is to shown.
CompoSensVarOrParam=Parameters4Search;
%CompoSensVarOrParam=Variables4Search;
%CompoSensVarOrParam=union(Variables4Search,Parameters4Search,'stable');

SelNewVarOrParam=varndparamid(CompoSensVarOrParam, VariableNames,ParameterNames);


 
meansensitivity=[sens(SelNewVarOrParam)]

return
%%

figure(10)
hold off

time=ExperimentData(:,1);
V=mean(StateFit2Data(:,2,SelectedFitByConstraint),3);
n=mean(StateFit2Data(:,3,SelectedFitByConstraint),3);
m=mean(StateFit2Data(:,4,SelectedFitByConstraint),3);
h=mean(StateFit2Data(:,5,SelectedFitByConstraint),3);
E_K=mean(BestFit(SelectedFitByConstraint,6),1);
barg_K=mean(BestFit(SelectedFitByConstraint,7),1);
E_Na=mean(BestFit(SelectedFitByConstraint,8),1);
barg_Na=mean(BestFit(SelectedFitByConstraint,9),1);
E_Cl=mean(BestFit(SelectedFitByConstraint,10),1);
G_Cl=mean(BestFit(SelectedFitByConstraint,11),1);




%plot(time,V-V(end),'r--',time,I_K,'b--',time,I_Na,'k--')
%hold on
%plot(time,I_K./(V-E_K),'b--',time,I_Na./(V-E_Na),'k--',time, I_K./(V-E_K)+I_Na./(V-E_Na)+G_Cl,'m--')
plot(time,barg_K.*n.^4,'m--',time,barg_Na.*m.^3.*h,'b-.',time, 0*time+G_Cl,'g-','linewidth',3)

%AX=legend('V','I_K','I_{Na}', 'g_{K}','g_{Na}','g_{K}+g_{Na}+g_L');
AX=legend('g_{K}','g_{Na}','g_L');
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',14)

set(gca,'XTick',[0 1 2 3 4 5 6])
aa = get(gca,'XTickLabel');
set(gca,'XTickLabel',aa,'fontsize',14)

%set(gca,'yTick',[0 0.5 1])
%aa = get(gca,'yTickLabel');
%set(gca,'yTickLabel',aa,'fontsize',14)

xlabel('Time (msec)','fontsize',20)
ylabel('Variables','fontsize',20)
axis([-.2 6.4 -5 40])


%return
%%
figure(20)
hold off

% var and param whose compositie sensitivity is to shown, in the same order
% as their name so that they will be labeled correctly. 


PointPlotOfVarOrParam4={'V_L', 'barg_L', 'C'}; 

PointPlotOfVarOrParam5={ 'barg_Na', 'V_L', 'barg_L'}; 

PointPlotOfVarOrParam6={'V_K', 'barg_K',  'V_Na'}; 

PointPlotOfVarOrParam=PointPlotOfVarOrParam6;  


%PointPlotOfVarOrParam=Parameters4Search;



plotVarOrParam=varndparamid(PointPlotOfVarOrParam, VariableNames,ParameterNames);

nn=1;
kk=FitByConstraint(1:nn);
%scaledselBestFit=BestFit(kk,1:NumberOfVariables+NumberOfParameters+1)...
%./(ones(length(BestFit(kk,1)),1)*((mean(BestFit(kk,1:NumberOfVariables+NumberOfParameters+1),1))+1e-10));

clr=colormap(cool(nn));

PointofBestFit=BestFit(kk,1:NumberOfVariables+NumberOfParameters+1);


plotfits=PointofBestFit(:,plotVarOrParam);
%plotfits=[PointofBestFit(:,plotVarOrParam(1:2)) PointofBestFit(:,end)]; % vs E


%boxplot(plotfits,'notch','on','labels',union(BoxPlotOfVarOrParam,'Er','stable'));

for i=1:length(plotfits(:,1))
plot3(plotfits(i,1),plotfits(i,2),plotfits(i,3),'ko','markerfacecolor',clr(i,:),'markersize',14)
hold on
end

[a,b]=meshgrid(0:.05:1, 0:.05:1);
c1=0.*a+0;

xx=.9+a*(1.5-.9);
yy=5.5+b*(7.25-5.5);
zz=5.75+b*(7.75-5.75);
mesh(xx, yy, zz, c1); 

%xlabel(PointPlotOfVarOrParam(1),'fontsize',20)
%ylabel(PointPlotOfVarOrParam(2),'fontsize',20)
%zlabel(PointPlotOfVarOrParam(3),'fontsize',20)

%xlabel('E_{Na}','fontsize',20)
%ylabel('g_{Na}','fontsize',20)
zlabel('d_{Na}','fontsize',20)


text(1.4,5, 7, 'g_{Na}','fontsize',20)
text(1.4,5, 7.5, 'E_{Na}','fontsize',20)


%xlabel('g_{Na}','fontsize',20)
%ylabel('d_{Na}','fontsize',20)

%set(gca,'YTick',[0  1  2])
aa = get(gca,'YTickLabel');
set(gca,'YTickLabel',aa,'fontsize',14)
grid on
hidden off
axis([-inf inf -inf inf -inf inf])
view(58, 17)
return
%%

% Box plot of best fitted initials and parameters relative to their mean
% values
%
%if TopNBestFit>0 && length(SelectAny)==0
figure(30)
hold off

% var and param whose compositie sensitivity is to shown, in the same order
% as their name so that they will be labeled correctly. 
BoxPlotOfVarOrParam={'E_K', 'g_K', 'd_K', 'V_K1', 'V_K2'};
BoxPlotOfVarOrParam={'E_Na', 'g_Na', 'd_Na', 'V_Na1', 'V_Na2'};
BoxPlotOfVarOrParam={'E_Cl', 'G_Cl','C', 'tau_K', 'tau_Na'};
BoxPlotOfVarOrParam={'el_Na','R','el_K'}; 
%BoxPlotOfVarOrParam={'V','g_K','C','R'};
BoxPlotOfVarOrParam=Parameters4Search;
%BoxPlotOfVarOrParam=Variables4Search;


plotVarOrParam=varndparamid(BoxPlotOfVarOrParam, VariableNames,ParameterNames);


kk=FitByConstraint(1:18);
scaledselBestFit=BestFit(kk,1:NumberOfVariables+NumberOfParameters+1)...
./(ones(length(BestFit(kk,1)),1)*((mean(BestFit(kk,1:NumberOfVariables+NumberOfParameters+1),1))+1e-10));

plotfits=[scaledselBestFit(:,plotVarOrParam),scaledselBestFit(:,NumberOfVariables+NumberOfParameters+1)];

boxplot(plotfits,'notch','on','labels',union(BoxPlotOfVarOrParam,'Er','stable'));

set(findobj(gca,'Type','text'),'FontSize',16)

txt = findobj(gca,'Type','text');
set(txt(1:end),'VerticalAlignment', 'Middle');

%set(gca,'YTick',[0  1  2])
%aa = get(gca,'YTickLabel');
%set(gca,'YTickLabel',aa,'fontsize',14)

ylabel('Mean-Scaled Values', 'fontsize', 20)

meanvalues=mean(BestFit(kk,1:NumberOfVariables+NumberOfParameters+1),1)
%end
%boxplotTopVarNdParam;
return
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

StopThreshold1=.00001; % or
%StopThreshold1=StopThreshold;
MaximalSearchIterate=inf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rerunsequence=isnan(BestFit(:,NumberOfVariables+NumberOfParameters+1)); % those that did not converge.

kk=1; %<NumberOfRun-sum(isnan(BestFit(:,NumberOfVariables+NumberOfParameters+1))); 
%rerunsequence=1:kk; % or rerun within the converged ones or 

rerunsequence=8;  % specify the list of re-runs or

%rerunsequence=FitByConstraint([3]); % the ones within constraints. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%% recalculate the top k fit %%%%%%%%%%%%
NumberOfVariables=length(VariableNames);
NumberOfParameters=length(ParameterNames);

InitialConditions1=BestFit(rerunsequence,1:NumberOfVariables+NumberOfParameters);

[FitInit1, FitParam1, TitError1, TitSens1, StateFit2Data1, Errorfunction1, SearchStepTaken1]=odelinesearch(ModelName,options,VariableNames, ParameterNames, Variables4Search, ...
    Parameters4Search, ExperimentData, PredictedState, InitialConditions1, RunOrNoRun, NumberOfSearchPartition, StopThreshold, MaximalSearchIterate);
                                                                                             
BestFit(rerunsequence,1:(2*NumberOfVariables+2*NumberOfParameters+1))=[FitInit1, FitParam1, TitError1, TitSens1]; % replace the old ones.

StateFit2Data(:,:,rerunsequence)=StateFit2Data1; 
Errorfunction(:,:,:,rerunsequence)=Errorfunction1;

%The output is last ranked in increasing value of the fit error. 
[BestFit,idx]=sortrows(BestFit,NumberOfVariables+NumberOfParameters+1); % sort in fit error
Errorfunction=Errorfunction(:,:,:,idx);
StateFit2Data=StateFit2Data(:,:,idx);

%save fittemp1.mat ModelName options VariableNames ParameterNames Variables4Search Parameters4Search ExperimentData PredictedState BestFit StateFit2Data Errorfunction NumberOfVariables NumberOfParameters RunOrNoRun NumberOfRun NumberOfSearchPartition transienttime StopThreshold MaximalSearchIterate InitialConditions RangeScale SearchVariablesNdParameters
%InitialConditions=BestFit(FitByConstraint(1:10),1:NumberOfVariables+NumberOfParameters);
%save bestofbestfittedinitialofmodel5.mat InitialConditions
%%
