function [out1, out2, out3] = HHmodel(t,x,flag,param)
%
%
%
%global V_Na V_K V_L barg_K barg_Na barg_L C Iin t_depol

V_K=param(1);
barg_K=param(2);
V_Na=param(3);
barg_Na=param(4);
V_L=param(5);
barg_L=param(6);
C=param(7);
Iin=param(8);
t_depol=param(9);
timescale=param(10);

V=x(1);n=x(2);m=x(3);h=x(4);
if nargin < 3 || isempty(flag)
   out1 = timescale*[-(barg_K*n^4*(V-V_K)+barg_Na*m^3*h*(V-V_Na)+barg_L*(V-V_L)-Iin*(t<t_depol).*(0<t))/(C+.5); 
           a_n(V)*(1-n)-b_n(V)*n;
           a_m(V)*(1-m)-b_m(V)*m;
           a_h(V)*(1-h)-b_h(V)*h;];
else
   switch(flag)
   case 'init'
     out1 = [0; 50];
     out2 = [-40,   .5, .5, .5];
     out3 = []; %odeset('Vectorized', 1);
     case 'events' 
     %sec1 = V_C-R*I_A; 
     sec1 = V;   
     sec2 = V;
     sec3 = V; 
     out1 = [sec1,sec2,sec3];
     out2 = [0,0,1];
     out3 = [1,-1,-1];
   otherwise
      error(['Unknown flag ''' flag ''.']);
   end
end; 
