function out1 = Dengmodel(t,x,flag,param)
%
%  Deng model of excitable membranes, March 2015
%
%

E_K=param(1);
barg_K=param(2);
b_K=param(3);
E_Na=param(4);
barg_Na=param(5);
b_Na=param(6);
E_G=param(7);
barg_G=param(8);
b_G=param(9);
C=param(10);

Iin=param(11);
t_depol=param(12);
timescale=param(13);

tau_K=param(14);
tau_Na=param(15);
%tau_G=param(16);

V_C=x(1);G_K=x(2);G_Na=x(3);G_G=x(4);

out1 = timescale*[-(barg_K*G_K.*(V_C-E_K)+barg_Na*G_Na.*(V_C-E_Na)+barg_G*G_G.*(V_C-E_G)-Iin*(t<t_depol).*(0<t))/(C+.5); 
           tau_K*(exp((V_C-E_K)./(b_K+1))-G_K);  % To avoid dividing 0 by shifting b_K to b_K+1.
           tau_Na*(exp((V_C-E_Na)./(b_Na+1))-G_Na);
           tau_Na*(exp(-(V_C-E_G)./(b_G+1))-G_G);
           ];
end 
