function [FitInit, FitParam, FitError, FitSens, StateFit2Data, Errorfunction, SearchStepTaken]=odelinesearch(ModelName,options,VariableNames, ParameterNames, Variables4Search, ...
    Parameters4Search, ExperimentData, PredictedState, InitialConditions, RunOrNoRun, NumberOfSearchPartition, ...
    StopThreshold, MaximalSearchIterate)
%
%
%

NumberOfVariables=length(VariableNames); 
NumberOfParameters=length(ParameterNames);
%%% total weight
weight=0;
for i4=3:2:length(ExperimentData(1,:))
    weight=weight+sum(ExperimentData(:,i4));
end

SearchStepTaken=[]; 

if RunOrNoRun>0
    
            numbrofrun=length(InitialConditions(:,1));

%%
%
% Output of the program
%
% FitInit=zeros(numbrofrun,NumberOfVariables);   % Local best fitted initials
% FitParam=zeros(numbrofrun,NumberOfParameters); % Local best fitted parameters
% FitError=zeros(numbrofrun,1);                  % Error between the data and the predicated at local best fit.
% FitSens=zeros(numbrofrun,NumberOfVariables+NumberOfParameters);    % Initial and parameter sensitivity of the local best fit. 
BestFit=zeros(numbrofrun,(NumberOfVariables+NumberOfParameters) + 1 + (NumberOfVariables+NumberOfParameters) + (NumberOfVariables+NumberOfParameters) + 4);    
% the first set is for the Values, the middle 1 is for the Error, 
% the second is for the Sensitivity of best fit, the last is for the
% initial fit, and 4 more columns record
% the search parameters: StopThreshold, MaximalSearchIterate,
% NumberOfSearchPartition, transienttime.

Errorfunction=zeros(2*NumberOfSearchPartition+1,2,NumberOfVariables+NumberOfParameters, numbrofrun)-1;
%
% column 1 for searched points of one parameter line, column 2 for 
% the corresponding error. Page dimension for NumberOfVarNdParm. Page2
% dimension is for the number of run
%

StateFit2Data=zeros(length(ExperimentData(:,1)),NumberOfVariables+1,numbrofrun);
%
% Same row length as Data, columns for state variables plus time, page for
% numbrofrun.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% Body of the search
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% Search variable and parameter in logical binary %%%%%%%
VariableNdParameterNames= union(VariableNames,ParameterNames,'stable');
VariablesNdParameters4Search = union(Variables4Search,Parameters4Search,'stable');

SearchVariablesNdParameters=zeros(1,NumberOfVariables+NumberOfParameters); %creat binary sequence with 1 for search 0 for nonsearch.
for k = 1:length(VariablesNdParameters4Search)
    jj = strcmp(VariablesNdParameters4Search(k),VariableNdParameterNames);
    SearchVariablesNdParameters = SearchVariablesNdParameters+jj;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    DirectionOfSearch=sign(InitialConditions);
    InitialSearchPoint = InitialConditions;
    
%%
%
% Run the search
%

%tic
SearchStepTaken=zeros(numbrofrun,1); 
for i=1:numbrofrun
    init=InitialSearchPoint(i,1:NumberOfVariables);
    param=InitialSearchPoint(i,(NumberOfVariables+1):end);
 
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %
            % Line search for one given initial fit in init and param.
            % File content: 
            % [ initfit, paramfit, statefit, err, sens, errorgraph, ~,~,~,~] =rawlinesearch(ModelName,ExperimentData,init,param,DirectionOfSearch,SearchVariablesNdParameters,StopThreshold,MaximalSearchIterate,NumberOfSearchPartition,transienttime);

            k=1; 
            chifactorthreshold=.0001;
            errold=0;
            errnew=1e+5;
            delerr=abs(errnew-errold);

            % Best-fit search
            while errnew>StopThreshold*weight && (delerr>StopThreshold && k<=MaximalSearchIterate)

                errold=errnew;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                    %[SearchedInit, SearchedParaNdTimeNdState] = searchedmodelstate(ModelName,ExperimentData,init,param,DirectionOfSearch,SearchVariablesNdParameters,NumberOfSearchPartition,transienttime);   

TotleSearchPartition=2*NumberOfSearchPartition+1;

SearchInit=init;
SearchPara=param;
SearchIintNdPara=[SearchInit SearchPara];

DataTime=ExperimentData(:,1);
DataLength=length(DataTime);
Tend=(DataTime(end))*1.1;% 10% longer than the data time.
Tstart=DataTime(1);

    NumberOfVar=length(init);
    NumberOfPar=length(param);
NumberOfVarNdParm=NumberOfVar+NumberOfPar;


NumberOfSearchedVarNdPara=NumberOfVarNdParm; % Generate searching points for all lines.

NumberOfModelRuns=NumberOfSearchedVarNdPara*TotleSearchPartition;

SearchedInitNdParaNdTimeNdState=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
% preallocate memory for all lines' model runs of one search iteration.

% Assign the init fit values for searching pionts of all lines. 
AA=ones(TotleSearchPartition*NumberOfVarNdParm,1)*SearchIintNdPara;

% Assign searching pionts on each line.
seq=0:(TotleSearchPartition-1);
for i1=1:NumberOfVarNdParm
    bk=1+(i1-1)*TotleSearchPartition;
    kk=i1*TotleSearchPartition;
    if abs(SearchIintNdPara(1,i1))<1e-8;
        b=DirectionOfSearch(i,i1)*.1; % radius of search
    else
        b=2*(SearchIintNdPara(1,i1));
    end
        db=b/NumberOfSearchPartition/2;
        par=seq*db;
    AA(bk:kk,i1)=par';
end
SearchedInitNdParaNdTimeNdState(:,1:NumberOfVarNdParm)=AA; % Keep the searching points.

% Actual searched initial and parameter.
NumberOfModelRuns=sum(SearchVariablesNdParameters)*TotleSearchPartition;

% Preallocate.
output=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
duplicate=zeros(NumberOfModelRuns,DataLength*(1+NumberOfVar)); %Preallocate for the states at observed times.
%duplicate temp memory;

ak=0;
for i1=1:NumberOfVarNdParm  % Assign the searching points only on the searching lines.
if SearchVariablesNdParameters(i1)==1
    j=1+ak*TotleSearchPartition;
    jj=(ak+1)*TotleSearchPartition;
    output(j:jj,:)=SearchedInitNdParaNdTimeNdState((1+(i1-1)*TotleSearchPartition):(i1*TotleSearchPartition),:);
    ak=ak+1;
end
end

parfor j=1:NumberOfModelRuns % Find the states at the observation time. 
    temphold=zeros(DataLength,1+NumberOfVar);
    initials=output(j,1:NumberOfVarNdParm);
    xinit=initials(1:NumberOfVar);
    param=initials(NumberOfVar+1:NumberOfVarNdParm);
    [t,x]=ode15s(ModelName,[Tstart,Tend],xinit, options, param);
    %%%%%%%% Find the right time %%%%%%%%
    for i1=1:DataLength % 
        indx0=(DataTime(i1)<=t);
        if sum(indx0)==0
            temphold(i1,1)=NaN; temphold(i1,1)=DataTime(i1);
            temphold(i1,2:end)=NaN; temphold(i1,2:end)=x(end,:);
        else
        TT=t(indx0);        
        XX=x(indx0,:);
            if Tend>Tstart
                temphold(i1,1)=TT(1);
                temphold(i1,2:end)=XX(1,:);
            else
                temphold(i1,1)=TT(end);
                temphold(i1,2:end)=XX(end,:);
            end
        end
    end
    duplicate(j, :)=temphold(1:end);
end
     
output(:,NumberOfVarNdParm + 1:end)= duplicate;  % Assign the state to output.
SearchedInit=output(:,1:NumberOfVar);
SearchedParaNdTimeNdState=output(:,NumberOfVar+1:end);        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                    %[init,param,~,err,~,~,~,~] = leasterror(ExperimentData,SearchVariablesNdParameters,SearchedInit, SearchedParaNdTimeNdState,chifactorthreshold);
                    NumberOfVarialbles2=length(SearchedInit(1,:));
                    NumberOfVarNdParam2=length(SearchVariablesNdParameters);
                    NumberOfParam2=NumberOfVarNdParam2-NumberOfVarialbles2;

                    NumberOfModelRuns2=length(SearchedInit(:,1));
                    DataLength2=length(ExperimentData(:,1));

                    SearchedPara=SearchedParaNdTimeNdState(:,1:NumberOfParam2);
                    SearchedState=zeros(DataLength2,NumberOfVarialbles2+1,NumberOfModelRuns2); % +1 for time dimension.

                    Error=zeros(NumberOfModelRuns2,1);

                    % Find error at searching piont on searching line.
                    for ii=1:NumberOfModelRuns2
                        searchedState=SearchedParaNdTimeNdState(ii,(NumberOfParam2+1):end);
                        SearchedState(:,:,ii)=vec2mat(searchedState,DataLength2)';
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                        %Error(ii)=errorfunction(ExperimentData,SearchedState(:,:,ii),SearchedPara(ii,:),chifactorthreshold);% error between data and predicted. 
                        
                                %%% total weight
                                %weight=0;
                                %for i4=3:2:length(ExperimentData(1,:))
                                %    weight=weight+sum(ExperimentData(:,i4));
                                %end

                                err=0;
                                if sum(isnan(SearchedState(:,:,ii)))>0
                                    err=NaN;
                                else
                                        DataState=ExperimentData(:,2:2:end-1);
                                        DataWeight=ExperimentData(:,3:2:end);
                                        DimensionOfData=length(DataState(1,:)); 
                                        chifactor=max(abs(DataState));
                                        idx=(chifactor<chifactorthreshold);
                                        chifactor(idx)=1;
                                    predictedstate=PredictedState(SearchedState(:,:,ii),SearchedPara(ii,:));
                                        for j=1:DimensionOfData % Total relative error.
                                            err=err+sum((DataState(:,j)-predictedstate(:,j)).^2.*DataWeight(:,j))/chifactor(j)^2;
                                        end
                                end
                                Error(ii)=sqrt(err);%/(weight+1e-10);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    end

                    [err,index]=min(Error); % Find the least error point.
                    init=SearchedInit(index,:);
                    param=SearchedPara(index,:);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                errnew=err;
                delerr=abs(errnew-errold);
                SearchStepTaken(i,1)=k;    
                k=k+1;
            end
            % End of best-fit search

fitinit=init; % in row vector 
fitparam=param; % in row vector 
fiterror=err/(weight+1e-10);
%%%%%%% One more run to generate the states at the bst fit [ initfit, paramfit fiterror] 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                    %[SearchedInit, SearchedParaNdTimeNdState] = searchedmodelstate(ModelName,ExperimentData,init,param,DirectionOfSearch,SearchVariablesNdParameters,NumberOfSearchPartition,transienttime);   
                    
TotleSearchPartition=2*NumberOfSearchPartition+1;

SearchInit=init;
SearchPara=param;
SearchIintNdPara=[SearchInit SearchPara];

DataTime=ExperimentData(:,1);
DataLength=length(DataTime);
Tend=(DataTime(end))*1.1;% 10% longer than the data time.
Tstart=DataTime(1);

    NumberOfVar=length(init);
    NumberOfPar=length(param);
NumberOfVarNdParm=NumberOfVar+NumberOfPar;


NumberOfSearchedVarNdPara=NumberOfVarNdParm; % Generate searching points for all lines.

NumberOfModelRuns=NumberOfSearchedVarNdPara*TotleSearchPartition;

SearchedInitNdParaNdTimeNdState=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
% preallocate memory for all lines' model runs of one search iteration.

% Assign the init fit values for searching pionts of all lines. 
AA=ones(TotleSearchPartition*NumberOfVarNdParm,1)*SearchIintNdPara;

% Assign searching pionts on each line.
seq=0:(TotleSearchPartition-1);
for i1=1:NumberOfVarNdParm
    ck=1+(i1-1)*TotleSearchPartition;
    kk=i1*TotleSearchPartition;
    if abs(SearchIintNdPara(1,i1))<1e-8;
        b=DirectionOfSearch(i,i1)*.1; % radius of search
    else
        b=2*(SearchIintNdPara(1,i1));
    end
        db=b/NumberOfSearchPartition/2;
        par=seq*db;
    AA(ck:kk,i1)=par';
end
SearchedInitNdParaNdTimeNdState(:,1:NumberOfVarNdParm)=AA; % Keep the searching points.

% Actual searched initial and parameter.
NumberOfModelRuns=sum(SearchVariablesNdParameters)*TotleSearchPartition;

% Preallocate.
output=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
duplicate=zeros(NumberOfModelRuns,DataLength*(1+NumberOfVar)); %Preallocate for the states at observed times.
%duplicate temp memory;

dk=0;
for i1=1:NumberOfVarNdParm  % Assign the searching points only on the searching lines.
if SearchVariablesNdParameters(i1)==1
    j=1+dk*TotleSearchPartition;
    jj=(dk+1)*TotleSearchPartition;
    output(j:jj,:)=SearchedInitNdParaNdTimeNdState((1+(i1-1)*TotleSearchPartition):(i1*TotleSearchPartition),:);
    dk=dk+1;
end
end

parfor j=1:NumberOfModelRuns % Find the states at the observation time. 
    temphold=zeros(DataLength,1+NumberOfVar);
    initials=output(j,1:NumberOfVarNdParm);
    xinit=initials(1:NumberOfVar);
    param=initials(NumberOfVar+1:NumberOfVarNdParm);
    [t,x]=ode15s(ModelName,[Tstart,Tend],xinit, options, param);
    %%%%%%%% Find the right time %%%%%%%%
    for i1=1:DataLength % 
        indx0=(DataTime(i1)<=t);
        if sum(indx0)==0
            temphold(i1,1)=NaN; temphold(i1,1)=DataTime(i1);
            temphold(i1,2:end)=NaN; temphold(i1,2:end)=x(end,:);
        else
        TT=t(indx0);        
        XX=x(indx0,:);
            if Tend>Tstart
                temphold(i1,1)=TT(1);
                temphold(i1,2:end)=XX(1,:);
            else
                temphold(i1,1)=TT(end);
                temphold(i1,2:end)=XX(end,:);
            end
        end
    end
    duplicate(j, :)=temphold(1:end);
end
%SearchedInitNdParaNdTimeNdState(:,NumberOfVarNdParm + 1:end)= duplicate;      
output(:,NumberOfVarNdParm + 1:end)= duplicate;  % Assign the state to output.
SearchedInit=output(:,1:NumberOfVar);
SearchedParaNdTimeNdState=output(:,NumberOfVar+1:end);        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
        %[~,~,state,~,searchinit,searchedpara,~,error] = leasterror(ExperimentData,SearchVariablesNdParameters,SearchedInit, SearchedParaNdTimeNdState,chifactorthreshold);

            NumberOfVarialbles2=length(SearchedInit(1,:));
            NumberOfVarNdParam2=length(SearchVariablesNdParameters);
            NumberOfParam2=NumberOfVarNdParam2-NumberOfVarialbles2;

            NumberOfModelRuns2=length(SearchedInit(:,1));
            DataLength2=length(ExperimentData(:,1));

            searchedpara=SearchedParaNdTimeNdState(:,1:NumberOfParam2);
            SearchedState=zeros(DataLength2,NumberOfVarialbles2+1,NumberOfModelRuns2); % +1 for time dimension.

            error=zeros(NumberOfModelRuns2,1);

            % Find error at searching piont on searching line.
            for ii=1:NumberOfModelRuns2
                searchedState=SearchedParaNdTimeNdState(ii,(NumberOfParam2+1):end);
                SearchedState(:,:,ii)=vec2mat(searchedState,DataLength2)';
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                        %error(ii)=errorfunction(ExperimentData,SearchedState(:,:,ii),searchedpara(ii,:),chifactorthreshold);% error between data and predicted. 
                        
                                %%% total weight
                                %weight=0;
                                %for i4=3:2:length(ExperimentData(1,:))
                                %    weight=weight+sum(ExperimentData(:,i4));
                                %end

                                err=0;
                                if sum(isnan(SearchedState(:,:,ii)))>0
                                    err=NaN;
                                else
                                        DataState=ExperimentData(:,2:2:end-1);
                                        DataWeight=ExperimentData(:,3:2:end);
                                        DimensionOfData=length(DataState(1,:)); 
                                        chifactor=max(abs(DataState));
                                        idx=(chifactor<chifactorthreshold);
                                        chifactor(idx)=1;
                                    predictedstate=PredictedState(SearchedState(:,:,ii),SearchedPara(ii,:));
                                        for j=1:DimensionOfData % Total relative error.
                                            err=err+sum((DataState(:,j)-predictedstate(:,j)).^2.*DataWeight(:,j))/chifactor(j)^2;
                                        end
                                end
                                error(ii)=sqrt(err)/(weight+1e-10);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            end

            [err,index]=min(error); % Find the least error point.
            state=SearchedState(:,:,index);
            searchinit=SearchedInit;
 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

statefit=state; % in row vector 
FitInit=searchinit; % in Matrix with column for points of searching line in the order of SearchVariablesNdParameters.
FitPara=searchedpara; % in Matrix with column for points of searching line
%FitState=searchedstate; % in 3D Array = Matrix of State + Page dimension for points of searching lines
FitError=error; % in Matrix with column for points of searching line

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        % sensitivity function go here. 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% File content of: 
                %[sens, errorgraph]=sensitivity(FitInit,FitPara,FitError, SearchVariablesNdParameters);
                NumberOfVarNdParm3=length(SearchVariablesNdParameters);
                NumberOfSearchedLine3=sum(SearchVariablesNdParameters);
                NumberOfModelRuns3=length(FitError);
                TotleSearchPartition3=NumberOfModelRuns3/NumberOfSearchedLine3;
                CenterOfSearchLines3=((TotleSearchPartition3-1)/2+1);

                errorgraph=zeros(TotleSearchPartition3,2,NumberOfVarNdParm3)-1; 
                % column 1 for searched points of one parameter line, column 2 for 
                % the corresponding error. Page dimension for NumberOfVarNdParm. 

                temp=[FitInit,FitPara];

                k=1;
                for i3=1:NumberOfVarNdParm3  % Assign the searching points only on the searching lines.
                if SearchVariablesNdParameters(i3)==1
                    errorgraph(:,:,i3)=[temp((1+(k-1)*TotleSearchPartition3):(k*TotleSearchPartition3),i3), FitError((1+(k-1)*TotleSearchPartition3):(k*TotleSearchPartition3))];
                    k=k+1;
                end
                end


                fitsens=zeros(1,NumberOfVarNdParm3);
                for i3=1:NumberOfVarNdParm3
                    if SearchVariablesNdParameters(i3)==1
                            d2error=errorgraph(CenterOfSearchLines3+1,2,i3)-2*errorgraph(CenterOfSearchLines3,2,i3)+errorgraph(CenterOfSearchLines3-1,2,i3);
                            dpara2=(errorgraph(CenterOfSearchLines3+1,1,i3)-errorgraph(CenterOfSearchLines3,1,i3))^2;
                        fitsens(i3)=(.5)*(errorgraph(CenterOfSearchLines3,2,i3)^2)*d2error/dpara2;
                    end
                end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        
        BestFit(i,1:2*(NumberOfVariables+NumberOfParameters)+1)=[ fitinit, fitparam, fiterror, fitsens];
        Errorfunction(:,:,:,i)=errorgraph;
        StateFit2Data(:,:,i)=statefit;
    if mod(i,10)==0
        [1 i]
    end
end

    BestFit(:,(2*(NumberOfVariables+NumberOfParameters)+1+1):(3*(NumberOfVariables+NumberOfParameters)+1))=InitialSearchPoint;
end
%toc
                            if RunOrNoRun==0 % Output initial conditions's fit errors, etc.
                                %numbrofrun=0;
                                VariableNdParameterNames= union(VariableNames,ParameterNames,'stable');
                                VariablesNdParameters4Search = union(Variables4Search,Parameters4Search,'stable');
                                DirectionOfSearch=sign(InitialConditions);
                                NoR=length(InitialConditions(:,1));
                                chifactorthreshold=.0001;
                                
                                BestFit=zeros(NoR,(NumberOfVariables+NumberOfParameters) + 1 + (NumberOfVariables+NumberOfParameters) + (NumberOfVariables+NumberOfParameters) + 4);    
                                % the first set is for the Values, the middle 1 is for the Error, 
                                % the second is for the Sensitivity of best fit, the last is for the
                                % initial fit, and 4 more columns record
                                % the search parameters: StopThreshold, MaximalSearchIterate,
                                % NumberOfSearchPartition, transienttime.

                                Errorfunction=zeros(2*NumberOfSearchPartition+1,2,NumberOfVariables+NumberOfParameters, NoR)-1;
                                %
                                % column 1 for searched points of one parameter line, column 2 for 
                                % the corresponding error. Page dimension for NumberOfVarNdParm. Page2
                                % dimension is for the number of run
                                %

                                StateFit2Data=zeros(length(ExperimentData(:,1)),NumberOfVariables+1,NoR);
                            %%%%%%% One more run to generate the states at the bst fit [ initfit, paramfit fiterror] 
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%% File content of: 
                                                %[SearchedInit, SearchedParaNdTimeNdState] = searchedmodelstate(ModelName,ExperimentData,init,param,DirectionOfSearch,SearchVariablesNdParameters,NumberOfSearchPartition,transienttime);   

                            SearchVariablesNdParameters=zeros(1,NumberOfVariables+NumberOfParameters); %creat binary sequence with 1 for search 0 for nonsearch.
                                for k = 1:length(VariablesNdParameters4Search)
                                    jj = strcmp(VariablesNdParameters4Search(k),VariableNdParameterNames);
                                    SearchVariablesNdParameters = SearchVariablesNdParameters+jj;
                                end
                            for i=1:NoR
                            init=InitialConditions(i,1:NumberOfVariables);
                            param=InitialConditions(i,(NumberOfVariables+1):end);
                            TotleSearchPartition=2*NumberOfSearchPartition+1;

                            SearchInit=init;
                            SearchPara=param;
                            SearchIintNdPara=[SearchInit SearchPara];

                            DataTime=ExperimentData(:,1);
                            DataLength=length(DataTime);
                            Tend=(DataTime(end))*1.1;% 10% longer than the data time.
                            Tstart=DataTime(1);

                                NumberOfVar=length(init);
                                NumberOfPar=length(param);
                            NumberOfVarNdParm=NumberOfVar+NumberOfPar;


                            NumberOfSearchedVarNdPara=NumberOfVarNdParm; % Generate searching points for all lines.

                            NumberOfModelRuns=NumberOfSearchedVarNdPara*TotleSearchPartition;

                            SearchedInitNdParaNdTimeNdState=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
                            % preallocate memory for all lines' model runs of one search iteration.

                            % Assign the init fit values for searching pionts of all lines. 
                            AA=ones(TotleSearchPartition*NumberOfVarNdParm,1)*SearchIintNdPara;

                            % Assign searching pionts on each line.
                            seq=0:(TotleSearchPartition-1);
                            for i1=1:NumberOfVarNdParm
                                k=1+(i1-1)*TotleSearchPartition;
                                kk=i1*TotleSearchPartition;
                                if abs(SearchIintNdPara(1,i1))<1e-8;
                                    b=DirectionOfSearch(i,i1)*.1; % radius of search
                                else
                                    b=2*(SearchIintNdPara(1,i1));
                                end
                                    db=b/NumberOfSearchPartition/2;
                                    par=seq*db;
                                AA(k:kk,i1)=par';
                            end
                            SearchedInitNdParaNdTimeNdState(:,1:NumberOfVarNdParm)=AA; % Keep the searching points.

                            % Actual searched initial and parameter.
                            NumberOfModelRuns=sum(SearchVariablesNdParameters)*TotleSearchPartition;

                            % Preallocate.
                            output=zeros(NumberOfModelRuns,NumberOfVarNdParm + DataLength*(1+NumberOfVar));
                            duplicate=zeros(NumberOfModelRuns,DataLength*(1+NumberOfVar)); %Preallocate for the states at observed times.
                            %duplicate temp memory;

                            k=0;
                            for i1=1:NumberOfVarNdParm  % Assign the searching points only on the searching lines.
                            if SearchVariablesNdParameters(i1)==1
                                j=1+k*TotleSearchPartition;
                                jj=(k+1)*TotleSearchPartition;
                                output(j:jj,:)=SearchedInitNdParaNdTimeNdState((1+(i1-1)*TotleSearchPartition):(i1*TotleSearchPartition),:);
                                k=k+1;
                            end
                            end

                            parfor j=1:NumberOfModelRuns % Find the states at the observation time. 
                                temphold=zeros(DataLength,1+NumberOfVar);
                                %initials=SearchedInitNdParaNdTimeNdState(j,1:NumberOfVarNdParm);
                                initials=output(j,1:NumberOfVarNdParm);
                                xinit=initials(1:NumberOfVar);
                                param=initials(NumberOfVar+1:NumberOfVarNdParm);
                                [t,x]=ode15s(ModelName,[Tstart,Tend],xinit, options, param);
                                %%%%%%%% Find the right time %%%%%%%%
                                for i1=1:DataLength % 
                                    indx0=(DataTime(i1)<=t);
                                    if sum(indx0)==0
                                    temphold(i1,1)=NaN; temphold(i1,1)=DataTime(i1);
                                    temphold(i1,2:end)=NaN; temphold(i1,2:end)=x(end,:);
                                    else
                                    TT=t(indx0);        
                                    XX=x(indx0,:);
                                        if Tend>Tstart
                                            temphold(i1,1)=TT(1);
                                            temphold(i1,2:end)=XX(1,:);
                                        else
                                            temphold(i1,1)=TT(end);
                                            temphold(i1,2:end)=XX(end,:);
                                        end
                                    end
                                end
                                duplicate(j, :)=temphold(1:end);
                            end
                            %SearchedInitNdParaNdTimeNdState(:,NumberOfVarNdParm + 1:end)= duplicate;      
                            output(:,NumberOfVarNdParm + 1:end)= duplicate;  % Assign the state to output.
                            SearchedInit=output(:,1:NumberOfVar);
                            SearchedParaNdTimeNdState=output(:,NumberOfVar+1:end);        
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%% File content of: 
                                    %[~,~,state,~,searchinit,searchedpara,~,error] = leasterror(ExperimentData,SearchVariablesNdParameters,SearchedInit, SearchedParaNdTimeNdState,chifactorthreshold);

                                        NumberOfVarialbles2=length(SearchedInit(1,:));
                                        NumberOfVarNdParam2=length(SearchVariablesNdParameters);
                                        NumberOfParam2=NumberOfVarNdParam2-NumberOfVarialbles2;

                                        NumberOfModelRuns2=length(SearchedInit(:,1));
                                        DataLength2=length(ExperimentData(:,1));
                                        
                                        SearchedPara=SearchedParaNdTimeNdState(:,1:NumberOfParam2);
                                        searchedpara=SearchedPara;
                                        SearchedState=zeros(DataLength2,NumberOfVarialbles2+1,NumberOfModelRuns2); % +1 for time dimension.

                                        error=zeros(NumberOfModelRuns2,1);

                                        % Find error at searching piont on searching line.
                                        for ii=1:NumberOfModelRuns2
                                            searchedState=SearchedParaNdTimeNdState(ii,(NumberOfParam2+1):end);
                                            SearchedState(:,:,ii)=vec2mat(searchedState,DataLength2)';
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%% File content of: 
                                                    %error(ii)=errorfunction(ExperimentData,SearchedState(:,:,ii),searchedpara(ii,:),chifactorthreshold);% error between data and predicted. 

                                                            %%% total weight
                                                            %weight=0;
                                                            %for i4=3:2:length(ExperimentData(1,:))
                                                            %    weight=weight+sum(ExperimentData(:,i4));
                                                            %end

                                                            err=0;
                                                            if sum(isnan(SearchedState(:,:,ii)))>0
                                                                err=NaN;
                                                            else
                                                                    DataState=ExperimentData(:,2:2:end-1);
                                                                    DataWeight=ExperimentData(:,3:2:end);
                                                                    DimensionOfData=length(DataState(1,:)); 
                                                                    chifactor=max(abs(DataState));
                                                                    idx=(chifactor<chifactorthreshold);
                                                                    chifactor(idx)=1;
                                                                predictedstate=PredictedState(SearchedState(:,:,ii),SearchedPara(ii,:));
                                                                    for j=1:DimensionOfData % Total relative error.
                                                                        err=err+sum((DataState(:,j)-predictedstate(:,j)).^2.*DataWeight(:,j))/chifactor(j)^2;
                                                                    end
                                                            end
                                                            error(ii)=sqrt(err)/(weight+1e-10);
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                                        end

                                        %[err,index]=min(error); %%%%%%%% changed here
                                        index=NumberOfSearchPartition+1; %%%%%%%% changed here
                                        fiterror=error(index); %%%%%%%% changed here
                                        state=SearchedState(:,:,index);
                                        searchinit=SearchedInit;

                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                            statefit=state; % in row vector 
                            FitInit=searchinit; % in Matrix with column for points of searching line in the order of SearchVariablesNdParameters.
                            FitPara=searchedpara; % in Matrix with column for points of searching line
                            %FitState=searchedstate; % in 3D Array = Matrix of State + Page dimension for points of searching lines
                            FitError=error; % in Matrix with column for points of searching line

                                        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                                    % sensitivity function go here. 
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%% File content of: 
                                            %[sens, errorgraph]=sensitivity(FitInit,FitPara,FitError, SearchVariablesNdParameters);
                                            NumberOfVarNdParm3=length(SearchVariablesNdParameters);
                                            NumberOfSearchedLine3=sum(SearchVariablesNdParameters);
                                            NumberOfModelRuns3=length(FitError);
                                            TotleSearchPartition3=NumberOfModelRuns3/NumberOfSearchedLine3;
                                            CenterOfSearchLines3=((TotleSearchPartition3-1)/2+1);

                                            errorgraph=zeros(TotleSearchPartition3,2,NumberOfVarNdParm3)-1; 
                                            % column 1 for searched points of one parameter line, column 2 for 
                                            % the corresponding error. Page dimension for NumberOfVarNdParm. 

                                            temp=[FitInit,FitPara];

                                            k=1;
                                            for i3=1:NumberOfVarNdParm3  % Assign the searching points only on the searching lines.
                                            if SearchVariablesNdParameters(i3)==1
                                                errorgraph(:,:,i3)=[temp((1+(k-1)*TotleSearchPartition3):(k*TotleSearchPartition3),i3), FitError((1+(k-1)*TotleSearchPartition3):(k*TotleSearchPartition3))];
                                                k=k+1;
                                            end
                                            end


                                            fitsens=zeros(1,NumberOfVarNdParm3);
                                            for i3=1:NumberOfVarNdParm3
                                                if SearchVariablesNdParameters(i3)==1
                                                        d2error=errorgraph(CenterOfSearchLines3+1,2,i3)-2*errorgraph(CenterOfSearchLines3,2,i3)+errorgraph(CenterOfSearchLines3-1,2,i3);
                                                        dpara2=(errorgraph(CenterOfSearchLines3+1,1,i3)-errorgraph(CenterOfSearchLines3,1,i3))^2;
                                                    fitsens(i3)=(.5)*(errorgraph(CenterOfSearchLines3,2,i3)^2)*d2error/dpara2;
                                                end
                                            end

                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                        fitinit=InitialConditions(i,1:NumberOfVariables);
                                        fitparam=InitialConditions(i,(NumberOfVariables+1):end);
                                    BestFit(i,1:2*(NumberOfVariables+NumberOfParameters)+1)=[ fitinit, fitparam, fiterror, fitsens];
                                    Errorfunction(:,:,:,i)=errorgraph;
                                    StateFit2Data(:,:,i)=statefit; 
                                    BestFit(i,(2*(NumberOfVariables+NumberOfParameters)+1+1):(3*(NumberOfVariables+NumberOfParameters)+1))=InitialConditions(i,:);
                            end
                            end
% 
% Save the control parameters.
%

%BestFit(1,(3*(NumberOfVariables+NumberOfParameters)+1+1):end)=[StopThreshold MaximalSearchIterate NumberOfSearchPartition transienttime];
FitInit=BestFit(:,1:NumberOfVariables); 
FitParam=BestFit(:,(NumberOfVariables+1):(NumberOfVariables+NumberOfParameters)); 
FitError=BestFit(:,NumberOfVariables+NumberOfParameters+1);
FitSens=BestFit(:,(NumberOfVariables+NumberOfParameters+1+1):(2*NumberOfVariables+2*NumberOfParameters+1));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%  End 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end