function predictedstate=fitfunction(PredictedState,param)
%
%
%
E_K=param(1);
barg_K=param(2);
E_Na=param(4);
barg_Na=param(5);
E_G=param(7);
barg_G=param(8);

PState=PredictedState(:,2:end);

% consist with the state of the model
V=PState(:,1);
G_K=PState(:,2);
G_Na=PState(:,3);
G_G=PState(:,4);

%Predicted state 1: cross-membrane voltage
predictedstate(:,1)=V;

%Predicted state 2: potassium current
predictedstate(:,2)=barg_K*G_K.*(V-E_K);
predictedstate(:,3)=barg_Na*G_Na.*(V-E_Na);
predictedstate(:,4)=barg_G*G_G.*(V-E_G);

end