%%
% Use for RunAnalysis, after 'sorttopfit.m'
%
scl=.04;

n=length(SelectedFitByConstraint);
clr=colormap(cool(2*n));

plot([-110 -110],[0 0],'-r','linewidth',3) % out of sight

hold on
%plot([-110 -110],[0 0],'kd','markersize',10)
hold on
plot([-110 -110],[0 0],'ro','markerfacecolor','w','markersize',10)
plot([-110 -110],[0 0],'m--','linewidth',3) % out of sight

plot([-110 -110],[0 0],'b-.','linewidth',3) % out of sight

plot([-110 -110],[0 0],'g-','linewidth',3) % out of sight

%AX=legend('HH Axon 17','Top (E<?) Fit','Composite V', 'Composite I_{K}','Composite I_{Na}');
AX=legend('HH Axon 17',' V', ' I_{K}',' I_{Na}', ' I_L');
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',14)



Vagrt=mean(StateFit2Data(:,2,SelectedFitByConstraint),3);
nagrt=mean(StateFit2Data(:,3,SelectedFitByConstraint),3);
magrt=mean(StateFit2Data(:,4,SelectedFitByConstraint),3);
hagrt=mean(StateFit2Data(:,5,SelectedFitByConstraint),3);
Param=mean(FitParam(SelectedFitByConstraint,:),3);


barg_Kposition=varndparamid({'barg_K'}, VariableNames,ParameterNames);
barg_K=mean(BestFit(SelectedFitByConstraint,barg_Kposition));

V_Kposition=varndparamid({'V_K'}, VariableNames,ParameterNames);
V_K=mean(BestFit(SelectedFitByConstraint,V_Kposition));

I_K=barg_K*nagrt.^4.*(Vagrt-V_K);

barg_Naposition=varndparamid({'barg_Na'}, VariableNames,ParameterNames);
barg_Na=mean(BestFit(SelectedFitByConstraint,barg_Naposition));

V_Naposition=varndparamid({'V_Na'}, VariableNames,ParameterNames);
V_Na=mean(BestFit(SelectedFitByConstraint,V_Naposition));

I_Na=barg_Na*magrt.^3.*hagrt.*(Vagrt-V_Na);

I_L=Cl(Vagrt,Param);

offst=0;
Vend=offst*(Vagrt(end)-50+2.5);%+.016;

plot(ExperimentData(:,1),scl*I_L,'g-','linewidth',3)

plot(ExperimentData(:,1),scl*I_K,'m--','linewidth',3)
plot(ExperimentData(:,1),scl*I_Na,'b-.','linewidth',3)

plot(ExperimentData(:,1),ExperimentData(:,2)-Vend,'r-','linewidth',3);

plot(ExperimentData(:,1),ExperimentData(:,2)-Vend,'r.','markersize',18);

for i=1:n
k=SelectedFitByConstraint(i);
%plot(StateFit2Data(:,1,k),(StateFit2Data(:,2,k)-50-offst*StateFit2Data(end,2,k)),'kd','markerfacecolor',clr(i,:),'markersize',8)
end

set(gca,'XTick',[0 1 2 3 4 5 6])
aa = get(gca,'XTickLabel');
set(gca,'XTickLabel',aa,'fontsize',14)

%ytick=[-20 0 50 100];
%set(gca,'yTick',ytick)
%bb = get(gca,'yTickLabel');
%set(gca,'yTickLabel',bb,'fontsize',14)


xlabel('Time (msec)','fontsize',20)
ylabel('Variables','fontsize',20)

axis([-.2 6.4 -80 80])

DataWeight=ExperimentData(:,3);

DataId=(DataWeight'>0);

plot(ExperimentData(:,1),(Vagrt-50+2.5)-Vend,'kd','markerfacecolor','w','markersize',7)

plot(ExperimentData(DataId,1),(Vagrt(DataId)-50+2.5)-Vend,'kd','markerfacecolor','c','markersize',7)

