%%
% Use for RunAnalysis, after 'sorttopfit.m'
%
% Plot the error against search parameters in dimensionless percentile. 
%

cc=colormap(cool(NumberOfVarNdParam));

selparam=varndparamid(ErrorPlotVarNdParam, VariableNames,ParameterNames);

inc=1/(NumberOfSearchPartition);
percentile = -1:inc:1;

AggrgtError=zeros(2*NumberOfSearchPartition+1,NumberOfVarNdParam);
for j=1:NumberOfVarNdParam
AggrgtError(:,j)=mean(Errorfunction(:,2,j,SelectedFitByConstraint),4);
end


cc=hsv(length(ErrorPlotVarNdParam));
%cc=colormap(cool(NumberOfVarNdParam));

k=1;
for j=selparam
plot(percentile,AggrgtError(:,j), 'color',cc(k,:), 'linewidth',2,'markersize',2)
k=k+1;
hold on
end


AX=legend(VariableNdParameterNames(selparam));
AX=legend(' g_{ Na}',' V_L',' g_{ L}');
LEG = findobj(AX,'type','text');
set(LEG,'FontSize',16)

for j=selparam
plot(percentile,AggrgtError(:,j), 'ko','markerfacecolor', 'w','markersize',4)
end

plot([0 0],[meanerrorperdatapoint meanerrorperdatapoint],'ko','markerfacecolor', [.7 .7 .7] ,'markersize',5)

set(gca,'XTick',[-1 -0.5 0 0.5 1],'XTickLabel',{'-100' '-50' '0' '50' '100'},'fontsize',14)

ytick=((0:1:4)*meanerrorperdatapoint*.4/4+meanerrorperdatapoint*.97);
%ytick=[ .1 .11 .12 ];
%set(gca,'yTick',ytick)
%bb = get(gca,'yTickLabel');
%set(gca,'yTickLabel',bb,'fontsize',14)

box on
xlabel('Percentile Change in Pararmeter','FontSize',20)
ylabel('Mean Error Per Data Point','FontSize',20)

axis([-1 1 meanerrorperdatapoint*.95 meanerrorperdatapoint*1.2])

axis([-1 1 .038 .1])

